/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.electric;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.przemyk.simpleplanes.EnergyStorageWithSet;
import xyz.przemyk.simpleplanes.client.ClientEventHandler;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.container.ElectricEngineContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class ElectricEngineUpgrade
extends EngineUpgrade
implements INamedContainerProvider {
    public static final int CAPACITY = 480000;
    public final EnergyStorageWithSet energyStorage = new EnergyStorageWithSet(480000);
    public final LazyOptional<EnergyStorage> energyStorageLazyOptional = LazyOptional.of(() -> this.energyStorage);

    public ElectricEngineUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.ELECTRIC_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (!this.planeEntity.getParked() && this.energyStorage.extractEnergy(40 * this.planeEntity.getFuelCost(), false) > 0) {
            this.updateClient();
        }
    }

    @Override
    public boolean isPowered() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    public void renderPowerHUD(MatrixStack matrixStack, HandSide side, int scaledWidth, int scaledHeight, float partialTicks) {
        int i = scaledWidth / 2;
        if (side == HandSide.LEFT) {
            ClientEventHandler.blit(matrixStack, -90, i - 91 - 29, scaledHeight - 22, 38, 44, 22, 21);
        } else {
            ClientEventHandler.blit(matrixStack, -90, i + 91, scaledHeight - 22, 38, 44, 22, 21);
        }
        int energy = this.energyStorage.getEnergyStored();
        if (energy > 0) {
            int energyScaled = energy * 15 / 480000;
            if (side == HandSide.LEFT) {
                ClientEventHandler.blit(matrixStack, -90, i - 91 - 29 + 3, scaledHeight - 22 + 16 - energyScaled, 60, 57 - energyScaled, 16, energyScaled + 2);
            } else {
                ClientEventHandler.blit(matrixStack, -90, i + 91 + 3, scaledHeight - 22 + 16 - energyScaled, 60, 57 - energyScaled, 16, energyScaled + 2);
            }
        }
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
        matrixStack.func_227860_a_();
        EntityType entityType = this.planeEntity.func_200600_R();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.func_227861_a_(0.0, -0.8, 0.65);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            matrixStack.func_227861_a_(0.0, 0.0, 1.1);
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(-0.4, -1.0, 0.3);
        matrixStack.func_227862_a_(0.82f, 0.82f, 0.82f);
        ClientUtil.renderItemModelAsBlock(matrixStack, Minecraft.func_71410_x(), buffer, packedLight, (Item)SimplePlanesItems.ELECTRIC_ENGINE.get());
        matrixStack.func_227865_b_();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageLazyOptional.invalidate();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("energy", this.energyStorage.getEnergyStored());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        int energy = nbt.func_74762_e("energy");
        this.energyStorage.setEnergy(Math.min(energy, 480000));
    }

    @Override
    public void writePacket(PacketBuffer buffer) {
        buffer.func_150787_b(this.energyStorage.getEnergyStored());
    }

    @Override
    public void readPacket(PacketBuffer buffer) {
        this.energyStorage.setEnergy(buffer.func_150792_a());
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public void openGui(ServerPlayerEntity playerEntity) {
        NetworkHooks.openGui((ServerPlayerEntity)playerEntity, (INamedContainerProvider)this, buffer -> buffer.func_150787_b(this.planeEntity.func_145782_y()));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("simpleplanes.electric_engine_container");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ElectricEngineContainer(id, playerInventory, this.planeEntity.func_145782_y());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorageLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void dropItems() {
        this.planeEntity.func_199703_a((IItemProvider)SimplePlanesItems.ELECTRIC_ENGINE.get());
    }
}

